using ConnectorLib.JSON;

namespace CrowdControl.Delegates.Effects.Implementations
{
    [Effect("status_invincible", 30)]
    public class Invincibility : Effect
    {
        public Invincibility(CrowdControl mod, NetworkClient client) : base(mod, client) { }
        
        public override EffectResponse Start(EffectRequest request)
        {
            PlayerController player = Manager.main.player;
            if (player == null) return EffectResponse.Retry(request.ID, StandardErrors.PlayerNotFound);
            
            player.SetInvincibility(true);
            return EffectResponse.Success(request.ID);
        }
        
        public override EffectResponse Stop(EffectRequest request)
        {
            PlayerController player = Manager.main.player;
            if (player == null) return EffectResponse.Retry(request.ID, StandardErrors.PlayerNotFound);
            
            player.SetInvincibility(false);
            return EffectResponse.Success(request.ID);
        }
    }
}